/*
 * Decompiled with CFR 0.152.
 */
package com.ubooquity.pref;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubooquity.pref.Category;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentPath {
    @JsonProperty(value="pathString")
    private String pathString;
    @JsonProperty(value="userName")
    private final List<String> authorizedUsers = new ArrayList<String>();
    @JsonProperty(value="category")
    private Category category = Category.others;
    @JsonProperty(value="isCalibreLibrary")
    private boolean isCalibreLibrary;

    public ContentPath() {
    }

    public ContentPath(String string, List<String> list, boolean bl) {
        this(string, list, Category.others, bl);
    }

    public ContentPath(String string, List<String> list, Category category, boolean bl) {
        this.pathString = string;
        this.isCalibreLibrary = bl;
        if (list != null) {
            this.authorizedUsers.addAll(list);
        }
        this.category = category;
    }

    public String getPathString() {
        return this.pathString;
    }

    public List<String> getAuthorizedUsers() {
        return this.authorizedUsers;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isCalibreLibrary() {
        return this.isCalibreLibrary;
    }

    public boolean isUserAuthorized(String string) {
        return string == null || this.authorizedUsers.contains(string);
    }

    public String getAuthorizedUsersLabel() {
        String string = "";
        if (this.authorizedUsers.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.authorizedUsers.get(0));
            for (int i2 = 1; i2 < this.authorizedUsers.size(); ++i2) {
                stringBuilder.append(", ");
                stringBuilder.append(this.authorizedUsers.get(i2));
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public String toString() {
        return "Content path: " + this.pathString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContentPath contentPath = (ContentPath)object;
        if (this.pathString != null ? !this.pathString.equals(contentPath.pathString) : contentPath.pathString != null) {
            return false;
        }
        return this.authorizedUsers.equals(contentPath.authorizedUsers);
    }

    public int hashCode() {
        int n = this.pathString != null ? this.pathString.hashCode() : 0;
        n = 31 * n + this.authorizedUsers.hashCode();
        return n;
    }
}

