/*global angular*/
/*jslint node: true */
/*jslint plusplus: true*/

'use strict';

var app = angular.module('adminApp', ['ngMaterial', 'ngSanitize']);

app.controller('adminController', function ($scope, $http, $interval, $mdToast, $mdDialog, $filter, $q, $sce, $window) {

    $scope.loadConfig = function () {
        $scope.showServerProgress = true;
        $http.get("admin-api/config").then(function (response) {
            $scope.config = response.data;
            $scope.originalConfig = angular.copy($scope.config);
            $scope.configModified = false;
            $scope.showServerProgress = false;
            $scope.buildLibraryUrl();
        });
    };

    $scope.saveConfig = function () {
        $scope.showServerProgress = true;
        $http.put("admin-api/config", $scope.config).then(function (response) {
            // if reverse proxy has changed, reload with new URL
            if ($scope.originalConfig.reverseProxyPrefix !== $scope.config.reverseProxyPrefix) {
                var prefix = $scope.config.reverseProxyPrefix,
                    adminUrl,
                    timer;
                adminUrl = prefix ? "/" + prefix + "/admin " : "/admin ";
                timer = $interval(function () {
                    $window.location.href = adminUrl;
                }, 2000, 1);
            } else {
                $scope.originalConfig = angular.copy($scope.config);
                $scope.configModified = false;
                $scope.showServerProgress = false;
                $scope.globalToast(response.data);
                $scope.buildLibraryUrl();
            }
        }, function (response) {
            $scope.globalToast("Failed to save configuration.");
        });
    };

    $scope.discardChanges = function (ev) {
        var confirm = $mdDialog.confirm()
            .title('Confirm discard')
            .textContent('Discard changes and reload configuration from server ?')
            .ariaLabel('discard changes')
            .targetEvent(ev)
            .ok('Yes')
            .cancel('No');
        $mdDialog.show(confirm).then(function () {
            $scope.loadConfig();
        });
    };

    $scope.loadServerSalt = function () {
        $http.get("admin-res/cryptoparams").then(function (response) {
            $scope.serverSalt = response.data.salt;
        });
    };

    $scope.buildLibraryUrl = function () {
        var url;
        if($scope.config){
            url = $window.location.protocol + "//" + $window.location.hostname + ':' + $scope.config.libraryPortNumber;
            if ($scope.config.reverseProxyPrefix && $scope.config.reverseProxyPrefix !== "") {
                url = url + '/' + $scope.config.reverseProxyPrefix;
            }
        }
        $scope.libraryUrl = url;
    };

    ////////////////////
    /// TAB: GENERAL  //
    ////////////////////

    $scope.loadVersion = function () {
        $http.get("admin-api/version").then(function (response) {
            $scope.versionInfo = response.data;
        });
    };

    $scope.loadNewVersionAvailable = function () {
        $http.get("admin-api/newversionavailable").then(function (response) {
            $scope.newVersionAvailable = response.data === "true";
        });
    };

    $scope.loadStatus = function () {
        $http.get("admin-api/status", {
            timeout: 3000
        }).then(function (response) {
            $scope.status = response.data;
            $scope.showUnreachableServer = false;
        }, function (response) {
            if (response.status == 403) {
                $window.location.reload();
            } else {
                $scope.showServerProgress = false; // just in case
                $scope.showUnreachableServer = true;
            }
        });
    };

    $scope.launchScan = function () {
        $http.get("admin-api/scan").then(function (response) {
            $scope.globalToast(response.data);
        });
    };

    $scope.loadThemes = function () {
        $http.get("admin-api/themes").then(function (response) {
            $scope.themes = response.data;
        });
    };

    $scope.createTheme = function (ev) {
        var confirm = $mdDialog.prompt()
            .title('Choose the name of the new theme')
            .ariaLabel('Theme name')
            .targetEvent(ev)
            .clickOutsideToClose(true)
            .ok('Create theme')
            .cancel('Cancel');
        $mdDialog.show(confirm).then(function (result) {
            if (result && result !== "") {
                $scope.showServerProgress = true;
                $http.post("admin-api/newtheme", result).then(function (response) {
                    $scope.loadThemes();
                    $scope.showServerProgress = false;
                    $scope.globalToast(response.data);
                });
            } else {
                $scope.globalToast("Cannot create theme with empty name");
            }
        });
    };

    //////////////////////////
    /// TAB: BOOKS (OPUS)   //
    //////////////////////////


    $scope.updateOpusHeight = function () {
        if ($scope.config) {
            $scope.config.opusHeight = Math.round($scope.config.opusWidth / 0.695);
        }
    };

    $scope.defaultOpusWidth = function () {
        $scope.config.OpusWidth = 160;
    };

    $scope.defaultOpusPagination = function () {
        $scope.config.opusPaginationNumber = 30;
    };

    $scope.clearOpusDatabase = function (ev) {
        var confirm = $mdDialog.confirm()
            .title('Database clearing confirmation')
            .htmlContent('Books data stored by Ubooquity will be cleared (without affecting your files).<br>A full rescan of your books will be done.<br> Do you want to continue ?')
            .ariaLabel('clear books')
            .targetEvent(ev)
            .ok('Yes, clear database')
            .cancel('Cancel');
        $mdDialog.show(confirm).then(function () {
            $http.get("admin-api/clearopus").then(function (response) {
                $scope.globalToast(response.data);
            });
        });
    };

    $scope.removeOpusPath = function (ev, path) {
        $scope.removePath($scope.config.opusPaths, path, ev);
    };

    $scope.displayOpusFolderDialog = function (ev) {
        $scope.currentlyEditedPathList = $scope.config.opusPaths;
        $scope.currentlyDisplayedDialog = "#folderselect";
        $scope.displayAddFolderDialog(ev);
    };

    $scope.displayOpusAuthorizationDialog = function (ev, contentPath) {
        $scope.displayAuthorizationDialog(ev, contentPath);
    };


    ////////////////////////
    /// TAB: RAW FILES    //
    ////////////////////////

    $scope.removeFilesPath = function (ev, path) {
        $scope.removePath($scope.config.filesPaths, path, ev);
    };

    $scope.displayFilesFolderDialog = function (ev) {
        $scope.currentlyEditedPathList = $scope.config.filesPaths;
        $scope.currentlyDisplayedDialog = "#folderselect";
        $scope.displayAddFolderDialog(ev);
    };

    $scope.displayFilesAuthorizationDialog = function (ev, contentPath) {
        $scope.displayAuthorizationDialog(ev, contentPath);
    };

    ////////////////////////
    /// TAB: SECURITY     //
    ////////////////////////

    function NewPasswordDialogController($scope, $mdDialog) {
        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };

        $scope.changeUserPassword = function () {
            var i, user, userList;
            userList = $scope.config.users;
            for (i = 0; i < userList.length; i++) {
                user = userList[i];
                if (user.name === $scope.editedUser.name) {
                    user.passwordHash = hex_hmac_sha256($scope.editedUser.password, $scope.serverSalt);
                    break;
                }
            }
            $mdDialog.cancel();
        };
    }

    $scope.openPasswordDialog = function (ev, userName) {
        $scope.editedUser = {
            "name": userName,
            "password": ""
        };

        $mdDialog.show({
            controller: NewPasswordDialogController,
            templateUrl: 'newpassword.tmpl.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose: true,
            scope: $scope,
            preserveScope: true
        });
    };

    $scope.deleteUser = function (ev, userName) {
        var i, user, userList, confirm = $mdDialog.confirm()
            .title('Confirm user deletion')
            .textContent('Do you want to delete user ' + userName + ' ?')
            .ariaLabel('delete user')
            .targetEvent(ev)
            .ok('Yes')
            .cancel('No');
        $mdDialog.show(confirm).then(function () {
            // remove user from user list
            userList = $scope.config.users;
            for (i = 0; i < userList.length; i++) {
                user = userList[i];
                if (user.name === userName) {
                    userList.splice(i, 1);
                    break;
                }
            }
            // remove user from all content paths
            $scope.removeUserFromPathList(userName, $scope.config.opusPaths);
            $scope.removeUserFromPathList(userName, $scope.config.filesPaths);
        });
    };

    $scope.removeUserFromPathList = function (name, pathList) {
        var i;
        for (i = 0; i < pathList.length; i++) {
            $scope.removeUSerFromContentPath(name, pathList[i]);
        }
    };

    $scope.removeUSerFromContentPath = function (name, contentPath) {
        var i, currentUser, userList;
        for (i = 0; i < contentPath.userName.length; i++) {
            currentUser = contentPath.userName[i];
            if (currentUser === name) {
                contentPath.userName.splice(i, 1);
                break;
            }
        }
    };

    function NewUserDialogController($scope, $mdDialog) {
        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };

        $scope.addUserToConfig = function () {
            if ($scope.editedUser.name === "" || $scope.editedUser.password === "") {
                $scope.globalToast('User name and password cannot be empty');
            } else {
                // check the new user does not exist yet
                var i, userList, user, hash, found = false;
                userList = $scope.config.users;
                for (i = 0; i < userList.length; i++) {
                    user = userList[i];
                    if (user.name === $scope.editedUser.name) {
                        found = true;
                        break;
                    }
                }
                if (found === true) {
                    $scope.globalToast('User ' + $scope.editedUser.name + ' already exists');
                } else {
                    hash = hex_hmac_sha256($scope.editedUser.password, $scope.serverSalt);
                    $scope.config.users.push({
                        "name": $scope.editedUser.name,
                        "passwordHash": hash
                    });
                }
            }
            $mdDialog.cancel();
        };
    }

    $scope.openNewUserDialog = function (ev) {
        $scope.editedUser = {
            "name": "",
            "password": ""
        };
        $mdDialog.show({
            controller: NewUserDialogController,
            templateUrl: 'newuser.tmpl.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose: true,
            scope: $scope,
            preserveScope: true
        });
    };

    /////////////////////
    /// TAB: ADVANCED  //
    /////////////////////

    $scope.defaultThumbnailCompressionQuality = function () {
        $scope.config.thumbnailCompressionQuality = 0.75;
    };

    //////////////////
    /// TAB: ABOUT  //
    //////////////////

    $scope.loadLicense = function () {
        $http.get("admin-res/about.txt").then(function (response) {
            $scope.license = response.data;
        });
    };


    ///////////////////////
    /// PATH MANAGEMENT  //
    ///////////////////////

    function AddFolderDialogController($scope, $mdDialog) {
        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $scope.currentlyEditedPathList = undefined;
            $scope.currentlyDisplayedDialog = undefined;
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };
    }

    $scope.displayAddFolderDialog = function (ev) {
        $mdDialog.show({
            controller: AddFolderDialogController,
            templateUrl: 'addfolder.tmpl.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose: true,
            scope: $scope,
            preserveScope: true
        });
        $scope.explore("");
    };

    function FolderDetailsDialogController($scope, $mdDialog, newPath) {
        $scope.category = "comics"
        $scope.newFolderName = newPath.replace(/^.*[\\\/]/, '')
        if($scope.newFolderName === ""){
            $scope.newFolderName = newPath
        }

        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };

        $scope.addFolderWithDetailsAndHide = function() {
            $scope.addFolderWithDetails(newPath);
            $mdDialog.hide();
        }
    }

    $scope.addFolderWithDetails = function(newPath) {
        var i, contentPath, found, path1, path2;
        for (i = 0; i < $scope.currentlyEditedPathList.length; i++) {
            contentPath = $scope.currentlyEditedPathList[i];

            path1 = contentPath.pathString.replace(/\\/g, "/") + "/"
            path2 = newPath.replace(/\\/g, "/") + "/"

            if (path1.includes(path2) || path2.includes(path1)) {
                found = true;
                $scope.dialogToast("ERROR: folder already shared or containing an already shared folder");
                break;
            }
        }
        if (!found) {
            $scope.currentlyEditedPathList.push({
                "pathString": newPath,
                "userName": [],
                "category": $scope.category,
                "isCalibreLibrary": $scope.isCalibreLibrary
            });
            $scope.dialogToast("Folder shared: " + newPath);
        }
    }

    $scope.addPath = function (pathString, ev) {
        if($scope.currentlyEditedPathList === $scope.config.filesPaths){
            $scope.category = "none";
            $scope.isCalibreLibrary = false;
            $scope.addFolderWithDetails(pathString);
        }else{
            $mdDialog.show({
                        controller: FolderDetailsDialogController,
                        templateUrl: 'folderdetails.tmpl.html',
                        parent: angular.element(document.body),
                        targetEvent: ev,
                        clickOutsideToClose: false,
                        scope: $scope,
                        preserveScope: true,
                        skipHide: true,
                        locals: {newPath: pathString}
                    });
        }
    };

    $scope.removePath = function (pathList, path, ev) {
        var confirm = $mdDialog.confirm()
            .title('Stop sharing this folder ?')
            .textContent(path)
            .ariaLabel('stop sharing')
            .targetEvent(ev)
            .ok('Yes')
            .cancel('No');
        $mdDialog.show(confirm).then(function () {
            var i, contentPath;
            for (i = 0; i < pathList.length; i++) {
                contentPath = pathList[i];
                if (contentPath.pathString === path) {
                    pathList.splice(i, 1);
                    break;
                }
            }
        });
    };

    ////////////////////////////////
    /// AUTHORIZATION MANAGEMENT  //
    ////////////////////////////////

    function AuthorizationDialogController($scope, $mdDialog) {
        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $scope.currentlyEditedContentPath.userName = $scope.getUsersFromAuthList($scope.authorizationList);
            $scope.currentlyEditedContentPath = undefined;
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };
    }

    $scope.displayAuthorizationDialog = function (ev, contentPath) {
        $scope.authorizationList = $scope.buildAuthList(contentPath.userName);
        $scope.currentlyEditedContentPath = contentPath;
        $mdDialog.show({
            controller: AuthorizationDialogController,
            templateUrl: 'authorization.tmpl.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose: true,
            scope: $scope,
            preserveScope: true
        });
    };

    ////////////////////
    //    ADVANCED    //
    ////////////////////

    $scope.regenerateSecretApiKey = function () {
        $scope.config.secretApiKey = Math.random().toString(36).substring(2, 12) + Math.random().toString(36).substring(2, 12) + Math.random().toString(36).substring(2, 12);
    };

    ////////////////////
    //     COMMON     //
    ////////////////////

    $scope.explore = function (path) {
        $scope.folderListing = [];
        $scope.explorerLoading = true;

        // cancel any previous request
        if ($scope.exploreCanceler !== undefined) {
            $scope.exploreCanceler.resolve();
        }
        $scope.exploreCanceler = $q.defer();

        $http.post("admin-api/explore", path, {
            timeout: $scope.exploreCanceler.promise
        }).then(function (response) {
            $scope.folderListing = response.data;
            $scope.explorerLoading = false;
        });
    };

    $scope.dialogToast = function (text) {
        var toast = $mdToast.simple()
            .parent($scope.currentlyDisplayedDialog)
            .position("bottom left")
            .textContent(text);
        $mdToast.show(toast);
    };

    $scope.globalToast = function (text) {
        var toast = $mdToast.simple()
            .position("bottom left")
            .textContent(text);
        $mdToast.show(toast);
    };

    $scope.buildAuthList = function (authUsers) {
        var i, userName, authList = [];
        for (i = 0; i < $scope.config.users.length; i++) {
            userName = $scope.config.users[i].name;
            authList.push({
                "name": userName,
                "hasAccess": authUsers.indexOf(userName) >= 0
            });
        }
        return authList;
    };

    $scope.formatUserList = function (userList) {
        var formattedString;
        if ($scope.config.isUserManagementEnabled === true) {
            if (userList.length === 0) {
                formattedString = "Nobody";
            } else {
                formattedString = userList.join(", ");
            }
        } else {
            formattedString = "Everyone";
        }
        return formattedString;
    };

    $scope.formatFolderInfo = function (folder) {
        var formattedString = folder.category;
        if (folder.isCalibreLibrary === true) {
            formattedString += " (Calibre library)";
        }
        return formattedString;
    };

    $scope.getUserListClass = function (userList) {
        if ($scope.config.isUserManagementEnabled === true && userList.length === 0) {
            return "highlighteditem";
        } else {
            return "";
        }
    };

    $scope.getUsersFromAuthList = function (authList) {
        var i, entry, nameList = [];
        for (i = 0; i < authList.length; i++) {
            entry = authList[i];
            if (entry.hasAccess === true) {
                nameList.push(entry.name);
            }
        }
        return nameList;
    };

    //////////////////////
    //   ONLINE HELP    //
    //////////////////////

    function HelpDialogController($scope, $mdDialog) {
        $scope.hide = function () {
            $mdDialog.hide();
        };

        $scope.cancel = function () {
            $scope.currentHelpContent = undefined;
            $mdDialog.cancel();
        };

        $scope.answer = function (answer) {
            $mdDialog.hide(answer);
        };
    }

    $scope.showHelp = function (ev, id) {
        $http.get("admin-res/help/" + id + ".html").then(function (response) {
            $scope.currentHelpContent = $sce.trustAsHtml(response.data);
        });

        $mdDialog.show({
            controller: HelpDialogController,
            templateUrl: 'help.tmpl.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose: true,
            scope: $scope,
            preserveScope: true
        });
    };

    ////////////////////
    // INITIALIZATION //
    ////////////////////

    $scope.showUnreachableServer = false;
    $scope.status = {
        "lastScan": "...",
        "currentOperation": "..."
    };
    $scope.libraryUrl = "";

    // let's go
    $scope.loadConfig();
    $scope.loadLicense();
    $scope.loadVersion();
    $scope.loadNewVersionAvailable();
    $scope.loadStatus();
    $scope.loadThemes();
    $scope.loadServerSalt();

    $scope.$watch('config.opusWidth', $scope.updateOpusHeight);
    $scope.$watch('config', function () {
        var previous = $scope.configModified;
        $scope.configModified = !angular.equals($scope.config, $scope.originalConfig);
    }, true);


    $interval($scope.loadStatus, 3000);

    // END INITIALIZATION


});
