/*global angular*/
/*jslint node: true */
/*jslint plusplus: true*/

'use strict';

var app = angular.module('loginApp', ['ngMaterial']);

app.controller('loginController', function ($scope, $http, $mdToast, $location, $window) {

    $scope.submitForm = function () {

        if ($scope.password !== undefined && $scope.password !== "") {
            $scope.showServerProgress = true;
            $http.get("admin-res/cryptoparams").then(function (response) {
                var serverSalt = response.data.salt,
                    serverTime = response.data.time;
                document.getElementById('servertime').value = serverTime;
                document.getElementById('remember').value = $scope.remember;
                document.getElementById('hash').value = hex_hmac_sha256(hex_hmac_sha256($scope.password, serverSalt), serverTime);
                $scope.password = "";
                document.forms['loginform'].submit();

            }, function () {
                $scope.showServerProgress = false; // just in case
                $scope.globalToast("Login failed due to a technical error on server side");
            });
        }
    };


    $scope.globalToast = function (text) {
        var toast = $mdToast.simple()
            .position("bottom left")
            .textContent(text);
        $mdToast.show(toast);
    };

    ////////////////////
    // INITIALIZATION //
    ////////////////////

    // remove trailing slash in URL as it prevents login from working
    var init = function () {
        var path, hasTrailingSlash, newPath;
        path = $location.absUrl();
        hasTrailingSlash = path[path.length - 1] === '/';
        if (hasTrailingSlash) {
            newPath = path.substr(0, path.length - 1);
            $window.location.href = newPath;
        }
    };
    init();
});
