/*global angular*/
/*jslint node: true */
/*jslint plusplus: true*/

'use strict';

var app = angular.module('passwordApp', ['ngMaterial']);

app.controller('passwordController', function ($scope, $http, $mdToast) {

    $scope.submitForm = function () {
        
        if ($scope.password !== undefined && $scope.password !== "" && $scope.password === $scope.repeatedpassword) {
            $scope.showServerProgress = true;
            $http.get("admin-res/cryptoparams").then(function (response) {
                var serverSalt = response.data.salt;

                document.getElementById('hash').value = hex_hmac_sha256($scope.password, serverSalt);
                $scope.password = "";
                $scope.repeatedpassword = "";
                document.forms['passwordform'].submit();

            }, function () {
                $scope.showServerProgress = false; // just in case
                $scope.globalToast("Failed to set password due to a technical error on server side");
            });
        } else {
            $scope.globalToast("You must enter the same password twice");
        }
    };


    $scope.globalToast = function (text) {
        var toast = $mdToast.simple()
            .position("bottom left")
            .textContent(text);
        $mdToast.show(toast);
    };

});